﻿using System;
using System.ComponentModel.Composition;
using VRM.Integration.FTP.MVI.Messages;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VRM.Integration.FTP.MVI.Processors;

namespace VRM.Integration.FTP.MVI.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.FTPDeterministicSearchRequest)]
    public class FTPDeterministicSearchMessageHandler : RequestResponseHandler
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="message"></param>
        /// <returns></returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);

                var processor = new FTPDeterministicSearchProcessor();

                return processor.Execute((FTPDeterministicSearchRequest)message);
            }
            catch (Exception ex)
            {
                FTPPersonSearchRequest msg = (FTPPersonSearchRequest)message;
                LogHelper.LogError(msg.OrganizationName, msg.UserId, "FTPDeterministicSearchMessageHandler.HandleRequestResponse", ex);
                throw new Exception(string.Format("FTPDeterministicSearchMessageHandler Error: {0}", ex.Message), ex);
            }
        }
    }
}